<?php
namespace app\models;

use yii\db\ActiveRecord;

class Order extends ActiveRecord
{
    public $wishes_checkbox;

    public static function tableName()
    {
        return 'order';
    }

    public function rules()
    {
        return [
            [['product_id', 'quantity', 'desired_date', 'delivery_address', 'payment_method'], 'required'],
            ['quantity', 'integer', 'min' => 1],
            ['desired_date', 'date', 'format' => 'php:Y-m-d'],
            ['wishes', 'string'],
            ['wishes_checkbox', 'boolean'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'product_id' => 'Товар',
            'quantity' => 'Количество',
            'desired_date' => 'Предполагаемая дата доставки',
            'delivery_address' => 'Адрес доставки',
            'payment_method' => 'Способ оплаты',
            'wishes' => 'Пожелания по заказу',
            'wishes_checkbox' => 'Пожелания по заказу',
        ];
    }

    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

    public function getProduct()
    {
        return $this->hasOne(Product::class, ['id' => 'product_id']);
    }
}