<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Вход для администратора';
?>
<div class="admin-login">
    <div class="row justify-content-center">
        <div class="col-lg-5">
            <div class="card shadow-sm border-danger">
                <div class="card-header bg-danger text-white text-center">
                    <i class="fas fa-lock fa-2x mb-3"></i>
                    <h1 class="card-title h3 mb-0"><?= Html::encode($this->title) ?></h1>
                    <p class="mb-0 mt-2 opacity-75">Доступ только для авторизованного персонала</p>
                </div>
                <div class="card-body p-4">
                    <?php $form = ActiveForm::begin([
                        'id' => 'admin-login-form',
                        'fieldConfig' => [
                            'template' => "{label}\n{input}\n{error}",
                            'inputOptions' => ['class' => 'form-control form-control-lg'],
                            'errorOptions' => ['class' => 'invalid-feedback']
                        ]
                    ]); ?>

                    <div class="mb-4">
                        <?= $form->field($model, 'phone')->textInput([
                            'autofocus' => true,
                            'value' => '8(999)999-99-99',
                            'placeholder' => 'Введите телефон администратора',
                            'class' => 'form-control form-control-lg text-center fw-bold'
                        ]) ?>
                    </div>

                    <div class="mb-4">
                        <?= $form->field($model, 'password')->passwordInput([
                            'placeholder' => 'Введите пароль',
                            'class' => 'form-control form-control-lg'
                        ]) ?>
                    </div>

                    <div class="d-grid">
                        <?= Html::submitButton('<i class="fas fa-sign-in-alt me-2"></i>Войти в панель управления', [
                            'class' => 'btn btn-danger btn-lg', 
                            'name' => 'login-button'
                        ]) ?>
                    </div>

                    <?php ActiveForm::end(); ?>

                    <div class="alert alert-warning mt-4 text-center">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Внимание!</strong> Не передавайте данные для входа третьим лицам.
                    </div>

                    <div class="text-center mt-3">
                        <?= Html::a('<i class="fas fa-arrow-left me-2"></i>Вернуться на сайт', ['site/index'], [
                            'class' => 'btn btn-outline-secondary btn-sm'
                        ]) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>