<?php
use yii\helpers\Html;
use yii\grid\GridView;

$this->title = 'Панель администратора - Заявки';
?>
<div class="admin-orders">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card shadow-sm">
                <div class="card-header bg-danger text-white d-flex justify-content-between align-items-center">
                    <h1 class="card-title mb-0">
                        <i class="fas fa-tachometer-alt me-2"></i>
                        <?= Html::encode($this->title) ?>
                    </h1>
                    <div>
                        <span class="badge bg-light text-dark me-2">
                            <i class="fas fa-list me-1"></i> Всего: <?= count($orders) ?>
                        </span>
                        <?= Html::a('<i class="fas fa-sign-out-alt me-2"></i>Выйти', ['admin/logout'], [
                            'class' => 'btn btn-light btn-sm'
                        ]) ?>
                    </div>
                </div>
                <div class="card-body">
                    <?php if (empty($orders)): ?>
                        <div class="text-center py-5">
                            <i class="fas fa-inbox fa-4x text-muted mb-4"></i>
                            <h3 class="text-muted">Заявок нет</h3>
                            <p class="text-muted">Нет заявок для отображения</p>
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <?= GridView::widget([
                                'dataProvider' => new \yii\data\ArrayDataProvider([
                                    'allModels' => $orders,
                                    'pagination' => [
                                        'pageSize' => 15,
                                    ],
                                    'sort' => [
                                        'attributes' => ['id', 'created_at', 'desired_date', 'status'],
                                        'defaultOrder' => ['created_at' => SORT_DESC]
                                    ],
                                ]),
                                'tableOptions' => ['class' => 'table table-hover table-striped align-middle'],
                                'columns' => [
                                    [
                                        'attribute' => 'id',
                                        'headerOptions' => ['style' => 'width: 80px;'],
                                        'contentOptions' => ['class' => 'fw-bold text-center']
                                    ],
                                    [
                                        'attribute' => 'user_id',
                                        'label' => 'Клиент',
                                        'value' => function ($model) {
                                            return Html::tag('div', 
                                                Html::tag('div', $model->user->full_name, ['class' => 'fw-bold']) .
                                                Html::tag('small', $model->user->phone, ['class' => 'text-muted']),
                                                ['class' => 'client-info']
                                            );
                                        },
                                        'format' => 'raw'
                                    ],
                                    [
                                        'attribute' => 'product_id',
                                        'label' => 'Товар',
                                        'value' => function ($model) {
                                            return Html::tag('span', $model->product->name, [
                                                'class' => 'badge bg-success'
                                            ]);
                                        },
                                        'format' => 'raw'
                                    ],
                                    [
                                        'attribute' => 'quantity',
                                        'label' => 'Кол-во',
                                        'headerOptions' => ['style' => 'width: 100px;'],
                                        'contentOptions' => ['class' => 'text-center fw-bold']
                                    ],
                                    [
                                        'attribute' => 'desired_date',
                                        'label' => 'Дата доставки',
                                        'format' => ['date', 'php:d.m.Y'],
                                        'headerOptions' => ['style' => 'width: 140px;'],
                                        'contentOptions' => function($model) {
                                            $today = date('Y-m-d');
                                            return [
                                                'class' => $model->desired_date < $today ? 'text-danger fw-bold' : 'text-dark'
                                            ];
                                        }
                                    ],
                                    [
                                        'attribute' => 'delivery_address',
                                        'label' => 'Адрес',
                                        'contentOptions' => ['class' => 'small'],
                                        'headerOptions' => ['style' => 'width: 200px;']
                                    ],
                                    [
                                        'attribute' => 'payment_method',
                                        'label' => 'Оплата',
                                        'value' => function ($model) {
                                            $icons = [
                                                'наличными' => '💵',
                                                'переводом' => '📱'
                                            ];
                                            $icon = $icons[$model->payment_method] ?? '';
                                            return Html::tag('span', $icon . ' ' . $model->payment_method, [
                                                'class' => 'badge bg-info'
                                            ]);
                                        },
                                        'format' => 'raw',
                                        'headerOptions' => ['style' => 'width: 150px;']
                                    ],
                                    [
                                        'attribute' => 'status',
                                        'label' => 'Статус',
                                        'value' => function ($model) {
                                            $statusClasses = [
                                                'Новая' => 'bg-warning',
                                                'Заказ принят' => 'bg-primary',
                                                'Заказ завершен' => 'bg-success',
                                                'Отменена' => 'bg-danger'
                                            ];
                                            $class = $statusClasses[$model->status] ?? 'bg-secondary';
                                            return Html::tag('span', $model->status, [
                                                'class' => "badge {$class}"
                                            ]);
                                        },
                                        'format' => 'raw',
                                        'headerOptions' => ['style' => 'width: 140px;'],
                                        'contentOptions' => ['class' => 'text-center']
                                    ],
                                    [
                                        'attribute' => 'created_at',
                                        'label' => 'Создана',
                                        'format' => ['datetime', 'php:d.m.Y H:i'],
                                        'headerOptions' => ['style' => 'width: 150px;'],
                                        'contentOptions' => ['class' => 'small text-muted']
                                    ],
                                    [
                                        'class' => 'yii\grid\ActionColumn',
                                        'header' => 'Действия',
                                        'template' => '{accept} {complete}',
                                        'headerOptions' => ['style' => 'width: 120px;'],
                                        'contentOptions' => ['class' => 'text-center'],
                                        'buttons' => [
                                            'accept' => function ($url, $model, $key) {
                                                if ($model->status === 'Новая') {
                                                    return Html::a('<i class="fas fa-check me-1"></i>Принять', 
                                                        ['update-status', 'id' => $model->id, 'status' => 'Заказ принят'], [
                                                        'class' => 'btn btn-success btn-sm',
                                                        'data-method' => 'post',
                                                        'data-confirm' => 'Подтвердить принятие заявки?'
                                                    ]);
                                                }
                                                return '';
                                            },
                                            'complete' => function ($url, $model, $key) {
                                                if ($model->status === 'Заказ принят') {
                                                    return Html::a('<i class="fas fa-flag-checkered me-1"></i>Завершить', 
                                                        ['update-status', 'id' => $model->id, 'status' => 'Заказ завершен'], [
                                                        'class' => 'btn btn-primary btn-sm',
                                                        'data-method' => 'post',
                                                        'data-confirm' => 'Подтвердить завершение заказа?'
                                                    ]);
                                                }
                                                return '';
                                            }
                                        ]
                                    ],
                                ],
                                'layout' => "{items}\n<div class=\"d-flex justify-content-between align-items-center p-3 border-top\">{pager}{summary}</div>",
                                'pager' => [
                                    'options' => ['class' => 'pagination mb-0'],
                                    'linkOptions' => ['class' => 'page-link'],
                                    'disabledPageCssClass' => 'page-link disabled'
                                ],
                                'summary' => 'Показано <b>{begin}-{end}</b> из <b>{totalCount}</b> заявок'
                            ]); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>