<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">
<head>
    <title><?= Html::encode($this->title) ?> | EcoFood</title>
    <?php $this->head() ?>
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        :root {
            --primary-color: #28a745;
            --primary-dark: #218838;
            --light-green: #d4edda;
        }
        
        .navbar-custom {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            box-shadow: 0 2px 15px rgba(40, 167, 69, 0.3);
        }
        
        .navbar-brand {
            font-weight: 800;
            font-size: 1.8rem;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.1);
        }
        
        .nav-link {
            font-weight: 600;
            margin: 0 5px;
            border-radius: 25px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .nav-link:hover {
            background: rgba(255,255,255,0.15);
            transform: translateY(-2px);
        }
        
        .btn-nav-primary {
            background: rgba(255,255,255,0.2);
            border: 2px solid rgba(255,255,255,0.3);
            border-radius: 25px;
            color: white !important;
            font-weight: 600;
            padding: 8px 20px;
            transition: all 0.3s ease;
        }
        
        .btn-nav-primary:hover {
            background: rgba(255,255,255,0.3);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(255,255,255,0.2);
        }
        
        .btn-nav-accent {
            background: #ffc107;
            border: none;
            border-radius: 25px;
            color: #212529 !important;
            font-weight: 700;
            padding: 8px 20px;
            transition: all 0.3s ease;
        }
        
        .btn-nav-accent:hover {
            background: #ffca2c;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(255, 193, 7, 0.4);
        }
        
        .footer-custom {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-top: 3px solid var(--primary-color);
            margin-top: auto;
        }
        
        .breadcrumb-custom {
            background: linear-gradient(90deg, #f8f9fa 0%, #ffffff 100%);
            border-bottom: 1px solid #dee2e6;
        }
        
        .scroll-to-top {
            position: fixed;
            bottom: 25px;
            right: 25px;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            border: none;
            color: white;
            font-size: 1.2rem;
            box-shadow: 0 4px 15px rgba(40, 167, 69, 0.4);
            transition: all 0.3s ease;
            display: none;
            z-index: 1000;
        }
        
        .scroll-to-top:hover {
            transform: translateY(-3px) scale(1.1);
            box-shadow: 0 6px 20px rgba(40, 167, 69, 0.6);
        }
        
        .dropdown-menu {
            border: none;
            box-shadow: 0 5px 25px rgba(0,0,0,0.15);
            border-radius: 12px;
            margin-top: 10px;
        }
        
        .dropdown-item {
            padding: 10px 20px;
            transition: all 0.2s ease;
        }
        
        .dropdown-item:hover {
            background: var(--light-green);
            padding-left: 25px;
        }
        
        .user-dropdown {
            background: rgba(255,255,255,0.1) !important;
            border: 1px solid rgba(255,255,255,0.2) !important;
            border-radius: 25px !important;
        }
        
        .user-dropdown:hover {
            background: rgba(255,255,255,0.2) !important;
        }
    </style>
</head>
<body class="d-flex flex-column h-100 bg-light">
<?php $this->beginBody() ?>

<header id="header">
    <?php
    NavBar::begin([
        'brandLabel' => '<i class="fas fa-leaf me-2"></i><span class="brand-text">EcoFood</span>',
        'brandUrl' => Yii::$app->homeUrl,
        'options' => [
            'class' => 'navbar navbar-expand-lg navbar-dark navbar-custom fixed-top py-2',
        ],
        'brandOptions' => [
            'class' => 'navbar-brand'
        ]
    ]);

    $menuItems = [
        [
            'label' => '<i class="fas fa-home me-2"></i>Главная',
            'url' => ['/site/index'],
            'encode' => false,
            'linkOptions' => ['class' => 'nav-link px-3']
        ],
        [
            'label' => '<i class="fas fa-info-circle me-2"></i>О нас',
            'url' => ['/site/about'],
            'encode' => false,
            'linkOptions' => ['class' => 'nav-link px-3']
        ],
        [
            'label' => '<i class="fas fa-envelope me-2"></i>Контакты',
            'url' => ['/site/contact'],
            'encode' => false,
            'linkOptions' => ['class' => 'nav-link px-3']
        ],
    ];

    if (Yii::$app->user->isGuest) {
        $menuItems[] = [
            'label' => '<i class="fas fa-sign-in-alt me-2"></i>Вход',
            'url' => ['/site/login'],
            'encode' => false,
            'linkOptions' => ['class' => 'nav-link btn-nav-primary px-4']
        ];
        $menuItems[] = [
            'label' => '<i class="fas fa-user-plus me-2"></i>Регистрация',
            'url' => ['/site/register'],
            'encode' => false,
            'linkOptions' => ['class' => 'nav-link btn-nav-accent px-4']
        ];
    } else {
        $menuItems[] = [
            'label' => '<i class="fas fa-shopping-basket me-2"></i>Мои заявки',
            'url' => ['/order/index'],
            'encode' => false,
            'linkOptions' => ['class' => 'nav-link px-3']
        ];
        $menuItems[] = [
            'label' => '<i class="fas fa-plus-circle me-2"></i>Новая заявка',
            'url' => ['/order/create'],
            'encode' => false,
            'linkOptions' => ['class' => 'nav-link btn-nav-accent px-4']
        ];
        
        $logoutItem = '<li class="nav-item dropdown">'
            . Html::beginTag('a', [
                'class' => 'nav-link user-dropdown dropdown-toggle px-4',
                'href' => '#',
                'role' => 'button',
                'data-bs-toggle' => 'dropdown',
                'aria-expanded' => 'false'
            ])
            . '<i class="fas fa-user-circle me-2"></i>' . Html::encode(Yii::$app->user->identity->full_name)
            . Html::endTag('a>')
            . '<ul class="dropdown-menu dropdown-menu-end">'
            . '<li><span class="dropdown-item-text text-muted small"><i class="fas fa-phone me-2"></i>' . Html::encode(Yii::$app->user->identity->phone) . '</span></li>'
            . '<li><hr class="dropdown-divider my-2"></li>'
            . '<li>'
            . Html::beginForm(['/site/logout'])
            . Html::submitButton(
                '<i class="fas fa-sign-out-alt me-2"></i>Выйти',
                ['class' => 'dropdown-item text-danger fw-bold']
            )
            . Html::endForm()
            . '</li>'
            . '</ul>'
            . '</li>';
            
        $menuItems[] = $logoutItem;
    }

    echo Nav::widget([
        'options' => ['class' => 'navbar-nav ms-auto align-items-center'],
        'items' => $menuItems,
    ]);

    NavBar::end();
    ?>
</header>

<main id="main" class="flex-shrink-0" role="main" style="padding-top: 80px;">
    <?php if (isset($this->params['breadcrumbs'])): ?>
        <nav aria-label="breadcrumb" class="breadcrumb-custom">
            <div class="container">
                <?= \yii\bootstrap5\Breadcrumbs::widget([
                    'links' => $this->params['breadcrumbs'],
                    'options' => ['class' => 'breadcrumb py-3 mb-0'],
                    'itemTemplate' => "<li class='breadcrumb-item'>{link}</li>",
                    'activeItemTemplate' => "<li class='breadcrumb-item active' aria-current='page'>{link}</li>"
                ]) ?>
            </div>
        </nav>
    <?php endif; ?>
    
    <?= $content ?>
</main>

<footer id="footer" class="footer-custom mt-auto py-4">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                <div class="d-flex align-items-center justify-content-center justify-content-md-start">
                    <i class="fas fa-leaf fa-2x text-success me-3"></i>
                    <div>
                        <h5 class="fw-bold mb-1 text-dark">EcoFood</h5>
                        <p class="text-muted small mb-0">Натуральные фермерские продукты</p>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6 text-center text-md-end">
                <div class="text-muted">
                    <p class="mb-1">
                        <i class="fas fa-phone me-2 text-success"></i>
                        <a href="tel:+78001234567" class="text-muted text-decoration-none">8 (800) 123-45-67</a>
                    </p>
                    <p class="small mb-0">
                        <i class="fas fa-copyright me-1"></i>
                        <?= Html::encode('Эко Еда ' . date('Y')) ?>
                        <span class="mx-2">•</span>
           
                    </p>
                </div>
            </div>
        </div>
    </div>
</footer>

<button class="scroll-to-top" id="btnBackToTop">
    <i class="fas fa-chevron-up"></i>
</button>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const backToTopButton = document.getElementById('btnBackToTop');
    
    window.addEventListener('scroll', () => {
        if (window.pageYOffset > 300) {
            backToTopButton.style.display = 'block';
        } else {
            backToTopButton.style.display = 'none';
        }
    });
    
    backToTopButton.addEventListener('click', () => {
        window.scrollTo({
            top: 0,
            behavior: 'smooth'
        });
    });
    
    const navLinks = document.querySelectorAll('.nav-link');
    navLinks.forEach(link => {
        link.addEventListener('mouseenter', function() {
            if (!this.classList.contains('btn-nav-accent') && !this.classList.contains('btn-nav-primary')) {
                this.style.transform = 'translateY(-2px)';
            }
        });
        link.addEventListener('mouseleave', function() {
            if (!this.classList.contains('btn-nav-accent') && !this.classList.contains('btn-nav-primary')) {
                this.style.transform = 'translateY(0)';
            }
        });
    });
});
</script>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>