<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;

$this->title = 'Создание заявки';
?>
<div class="order-create">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card shadow-sm">
                <div class="card-header bg-success text-white">
                    <h1 class="card-title mb-0">
                        <i class="fas fa-plus-circle me-2"></i>
                        <?= Html::encode($this->title) ?>
                    </h1>
                </div>
                <div class="card-body p-4">
                    <?php $form = ActiveForm::begin([
                        'fieldConfig' => [
                            'template' => "{label}\n{input}\n{error}",
                            'inputOptions' => ['class' => 'form-control'],
                            'errorOptions' => ['class' => 'invalid-feedback']
                        ]
                    ]); ?>

                    <div class="mb-4">
                        <label class="form-label fw-bold text-dark">Категория товаров</label>
                        <select class="form-control form-control-lg" id="category-select">
                            <option value="">Выберите категорию</option>
                            <?php foreach ($categories as $category): ?>
                                <option value="<?= $category->id ?>"><?= $category->name ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="mb-4">
                        <?= $form->field($model, 'product_id')->dropDownList([], [
                            'prompt' => 'Выберите товар',
                            'id' => 'product-select',
                            'class' => 'form-control form-control-lg'
                        ]) ?>
                    </div>

                    <div class="mb-4">
                        <?= $form->field($model, 'quantity')->textInput([
                            'type' => 'number', 
                            'min' => 1,
                            'class' => 'form-control form-control-lg',
                            'placeholder' => 'Введите количество'
                        ]) ?>
                    </div>

                    <div class="mb-4">
                        <?= $form->field($model, 'desired_date')->textInput([
                            'type' => 'date',
                            'class' => 'form-control form-control-lg'
                        ]) ?>
                    </div>

                    <div class="mb-4">
                        <?= $form->field($model, 'delivery_address')->textarea([
                            'rows' => 3,
                            'class' => 'form-control',
                            'placeholder' => 'Укажите полный адрес доставки...'
                        ]) ?>
                    </div>

                    <div class="mb-4">
                        <?= $form->field($model, 'payment_method')->dropDownList([
                            'наличными' => '💵 Наличными',
                            'переводом' => '📱 Переводом по номеру телефона'
                        ], [
                            'prompt' => 'Выберите способ оплаты',
                            'class' => 'form-control form-control-lg'
                        ]) ?>
                    </div>

                    <div class="mb-4">
                        <div class="form-check form-switch mb-3">
                            <?= $form->field($model, 'wishes_checkbox')->checkbox([
                                'id' => 'wishes-checkbox',
                                'class' => 'form-check-input',
                                'template' => "<div class=\"form-check form-switch\">{input} {label}</div>\n{error}"
                            ]) ?>
                        </div>

                        <?= $form->field($model, 'wishes')->textarea([
                            'rows' => 3,
                            'id' => 'wishes-text',
                            'class' => 'form-control',
                            'style' => 'display: none;',
                            'placeholder' => 'Укажите ваши пожелания по доставке...'
                        ]) ?>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <?= Html::a('<i class="fas fa-arrow-left me-2"></i>Назад', ['index'], [
                            'class' => 'btn btn-outline-secondary me-md-2'
                        ]) ?>
                        <?= Html::submitButton('<i class="fas fa-paper-plane me-2"></i>Отправить заявку', [
                            'class' => 'btn btn-success btn-lg px-4'
                        ]) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$url = Url::to(['order/products']);
$script = <<< JS
    $('#wishes-checkbox').change(function() {
        if (this.checked) {
            $('#wishes-text').show().focus();
        } else {
            $('#wishes-text').hide().val('');
        }
    });

    $('#category-select').change(function() {
        var categoryId = $(this).val();
        var productSelect = $('#product-select');
        
        if (categoryId) {
            productSelect.prop('disabled', true);
            productSelect.html('<option value="">Загрузка товаров...</option>');
            
            $.get('$url', {category_id: categoryId}, function(data) {
                productSelect.empty();
                productSelect.append($('<option>').text('Выберите товар').attr('value', ''));
                $.each(data, function(index, product) {
                    productSelect.append($('<option>').text(product.name).attr('value', product.id));
                });
                productSelect.prop('disabled', false);
            }).fail(function() {
                productSelect.html('<option value="">Ошибка загрузки</option>');
            });
        } else {
            productSelect.empty().append($('<option>').text('Выберите товар').attr('value', ''));
        }
    });
    
    // Устанавливаем минимальную дату как сегодня
    var today = new Date().toISOString().split('T')[0];
    $('#order-desired_date').attr('min', today);
JS;
$this->registerJs($script);