<?php
use yii\helpers\Html;
use yii\grid\GridView;

$this->title = 'Мои заявки';
?>
<div class="order-index">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h1 class="card-title mb-0">
                        <i class="fas fa-list-alt me-2"></i>
                        <?= Html::encode($this->title) ?>
                    </h1>
                    <?= Html::a('<i class="fas fa-plus-circle me-2"></i>Новая заявка', ['create'], [
                        'class' => 'btn btn-light btn-sm'
                    ]) ?>
                </div>
                <div class="card-body">
                    <?php if (empty($orders)): ?>
                        <div class="text-center py-5">
                            <i class="fas fa-inbox fa-4x text-muted mb-4"></i>
                            <h3 class="text-muted">У вас пока нет заявок</h3>
                            <p class="text-muted mb-4">Создайте первую заявку на доставку фермерских продуктов</p>
                            <?= Html::a('<i class="fas fa-plus-circle me-2"></i>Создать заявку', ['create'], [
                                'class' => 'btn btn-success btn-lg'
                            ]) ?>
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <?= GridView::widget([
                                'dataProvider' => new \yii\data\ArrayDataProvider([
                                    'allModels' => $orders,
                                    'pagination' => [
                                        'pageSize' => 10,
                                    ],
                                    'sort' => [
                                        'attributes' => ['id', 'created_at', 'desired_date'],
                                        'defaultOrder' => ['created_at' => SORT_DESC]
                                    ],
                                ]),
                                'tableOptions' => ['class' => 'table table-hover table-striped'],
                                'columns' => [
                                    [
                                        'attribute' => 'id',
                                        'headerOptions' => ['style' => 'width: 80px;'],
                                        'contentOptions' => ['class' => 'fw-bold text-center']
                                    ],
                                    [
                                        'attribute' => 'product_id',
                                        'label' => 'Товар',
                                        'value' => function ($model) {
                                            return Html::tag('span', $model->product->name, [
                                                'class' => 'badge bg-success'
                                            ]);
                                        },
                                        'format' => 'raw'
                                    ],
                                    [
                                        'attribute' => 'quantity',
                                        'headerOptions' => ['style' => 'width: 100px;'],
                                        'contentOptions' => ['class' => 'text-center fw-bold']
                                    ],
                                    [
                                        'attribute' => 'desired_date',
                                        'label' => 'Желаемая дата',
                                        'format' => ['date', 'php:d.m.Y'],
                                        'headerOptions' => ['style' => 'width: 150px;']
                                    ],
                                    [
                                        'attribute' => 'delivery_address',
                                        'label' => 'Адрес доставки',
                                        'contentOptions' => ['class' => 'small']
                                    ],
                                    [
                                        'attribute' => 'payment_method',
                                        'label' => 'Оплата',
                                        'value' => function ($model) {
                                            $icons = [
                                                'наличными' => '💵',
                                                'переводом' => '📱'
                                            ];
                                            $icon = $icons[$model->payment_method] ?? '';
                                            return $icon . ' ' . $model->payment_method;
                                        },
                                        'format' => 'raw',
                                        'headerOptions' => ['style' => 'width: 180px;']
                                    ],
                                    [
                                        'attribute' => 'status',
                                        'label' => 'Статус',
                                        'value' => function ($model) {
                                            $statusClasses = [
                                                'Новая' => 'bg-primary',
                                                'В обработке' => 'bg-warning',
                                                'Подтверждена' => 'bg-info',
                                                'Доставлено' => 'bg-success',
                                                'Отменена' => 'bg-danger'
                                            ];
                                            $class = $statusClasses[$model->status] ?? 'bg-secondary';
                                            return Html::tag('span', $model->status, [
                                                'class' => "badge {$class}"
                                            ]);
                                        },
                                        'format' => 'raw',
                                        'headerOptions' => ['style' => 'width: 140px;'],
                                        'contentOptions' => ['class' => 'text-center']
                                    ],
                                    [
                                        'attribute' => 'created_at',
                                        'label' => 'Создана',
                                        'format' => ['datetime', 'php:d.m.Y H:i'],
                                        'headerOptions' => ['style' => 'width: 160px;'],
                                        'contentOptions' => ['class' => 'small text-muted']
                                    ],
                                ],
                                'layout' => "{items}\n<div class=\"d-flex justify-content-between align-items-center p-3\">{pager}{summary}</div>",
                                'pager' => [
                                    'options' => ['class' => 'pagination mb-0'],
                                    'linkOptions' => ['class' => 'page-link'],
                                    'disabledPageCssClass' => 'page-link disabled'
                                ],
                                'summary' => 'Показано <b>{begin}-{end}</b> из <b>{totalCount}</b> заявок'
                            ]); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>