<?php
use yii\helpers\Html;

$this->title = 'Ошибка ' . $exception->statusCode;
?>
<div class="site-error">
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="card shadow-sm border-danger">
                <div class="card-header bg-danger text-white text-center">
                    <i class="fas fa-exclamation-triangle fa-2x mb-3"></i>
                    <h1 class="card-title mb-0"><?= Html::encode($this->title) ?></h1>
                </div>
                <div class="card-body text-center">
                    <div class="alert alert-danger">
                        <i class="fas fa-times-circle me-2"></i>
                        <?= nl2br(Html::encode($exception->getMessage())) ?>
                    </div>
                    
                    <div class="mt-4">
                        <p class="text-muted">
                            Пожалуйста, свяжитесь с нами, если вы считаете, что это ошибка сервера.
                        </p>
                        <div class="d-grid gap-2 d-sm-flex justify-content-sm-center">
                            <?= Html::a('<i class="fas fa-home me-2"></i>На главную', ['site/index'], [
                                'class' => 'btn btn-primary'
                            ]) ?>
                            <?= Html::a('<i class="fas fa-envelope me-2"></i>Связаться с нами', ['site/contact'], [
                                'class' => 'btn btn-outline-primary'
                            ]) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>