<?php
use yii\helpers\Html;

/** @var yii\web\View $this */
?>
<div class="site-index">
    <?php if (Yii::$app->user->isGuest): ?>
        <div class="hero-section text-center py-5 mb-5 bg-light rounded-3">
            <div class="container">
                <i class="fas fa-leaf fa-4x text-success mb-4"></i>
                <h1 class="display-4 fw-bold text-success mb-4">Добро пожаловать в Эко Еду!</h1>
                <p class="lead fs-4 text-muted mb-5">
                    Натуральные фермерские продукты с доставкой до вашего дома
                </p>
                <div class="row justify-content-center g-4">
                    <div class="col-md-3">
                        <div class="feature-card p-4 rounded shadow-sm">
                            <i class="fas fa-seedling fa-2x text-success mb-3"></i>
                            <h5>Экологично</h5>
                            <p class="text-muted small">Без химии и ГМО</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="feature-card p-4 rounded shadow-sm">
                            <i class="fas fa-truck fa-2x text-success mb-3"></i>
                            <h5>Быстрая доставка</h5>
                            <p class="text-muted small">В день заказа</p>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="feature-card p-4 rounded shadow-sm">
                            <i class="fas fa-medal fa-2x text-success mb-3"></i>
                            <h5>Гарантия качества</h5>
                            <p class="text-muted small">От проверенных фермеров</p>
                        </div>
                    </div>
                </div>
                <div class="mt-5">
                    <?= Html::a('<i class="fas fa-user-plus me-2"></i>Регистрация', ['site/register'], [
                        'class' => 'btn btn-success btn-lg px-4 me-3'
                    ]) ?>
                    <?= Html::a('<i class="fas fa-sign-in-alt me-2"></i>Вход', ['site/login'], [
                        'class' => 'btn btn-outline-success btn-lg px-4'
                    ]) ?>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="hero-section text-center py-5 mb-5 bg-success text-white rounded-3">
            <div class="container">
                <i class="fas fa-leaf fa-4x mb-4"></i>
                <h1 class="display-5 fw-bold mb-4">Добро пожаловать, <?= Html::encode(Yii::$app->user->identity->full_name) ?>!</h1>
                <p class="lead fs-4 mb-5">
                    Свежие продукты уже ждут вас
                </p>
                <div class="d-flex justify-content-center gap-3 flex-wrap">
                    <?= Html::a('<i class="fas fa-list me-2"></i>Мои заявки', ['order/index'], [
                        'class' => 'btn btn-light btn-lg px-4'
                    ]) ?>
                    <?= Html::a('<i class="fas fa-plus-circle me-2"></i>Создать заявку', ['order/create'], [
                        'class' => 'btn btn-outline-light btn-lg px-4'
                    ]) ?>
                </div>
            </div>
        </div>
        
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="row g-4">
                    <div class="col-md-6">
                        <div class="card h-100 border-0 shadow-sm">
                            <div class="card-body text-center">
                                <i class="fas fa-shopping-basket fa-2x text-success mb-3"></i>
                                <h5 class="card-title">Быстрый заказ</h5>
                                <p class="card-text text-muted">Создайте новую заявку на доставку свежих продуктов</p>
                                <?= Html::a('Создать заявку', ['order/create'], [
                                    'class' => 'btn btn-success stretched-link'
                                ]) ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card h-100 border-0 shadow-sm">
                            <div class="card-body text-center">
                                <i class="fas fa-history fa-2x text-primary mb-3"></i>
                                <h5 class="card-title">История заказов</h5>
                                <p class="card-text text-muted">Просмотрите ваши предыдущие заказы и их статусы</p>
                                <?= Html::a('Мои заявки', ['order/index'], [
                                    'class' => 'btn btn-primary stretched-link'
                                ]) ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>