<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Вход в систему';
?>
<div class="site-login">
    <div class="row justify-content-center">
        <div class="col-lg-5">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white text-center">
                    <i class="fas fa-sign-in-alt fa-2x mb-3"></i>
                    <h1 class="card-title h3 mb-0"><?= Html::encode($this->title) ?></h1>
                </div>
                <div class="card-body p-4">
                    <?php $form = ActiveForm::begin([
                        'id' => 'login-form',
                        'fieldConfig' => [
                            'template' => "{label}\n{input}\n{error}",
                            'inputOptions' => ['class' => 'form-control'],
                            'errorOptions' => ['class' => 'invalid-feedback']
                        ]
                    ]); ?>

                    <div class="mb-3">
                        <?= $form->field($model, 'phone')->textInput([
                            'autofocus' => true,
                            'placeholder' => '+7 (XXX) XXX-XX-XX',
                            'class' => 'form-control form-control-lg'
                        ]) ?>
                    </div>

                    <div class="mb-3">
                        <?= $form->field($model, 'password')->passwordInput([
                            'class' => 'form-control form-control-lg',
                            'placeholder' => 'Введите ваш пароль'
                        ]) ?>
                    </div>

                    <div class="mb-4">
                        <?= $form->field($model, 'rememberMe')->checkbox([
                            'template' => "<div class=\"form-check\">{input} {label}</div>\n{error}",
                            'class' => 'form-check-input',
                            'labelOptions' => ['class' => 'form-check-label']
                        ]) ?>
                    </div>

                    <div class="d-grid">
                        <?= Html::submitButton('<i class="fas fa-sign-in-alt me-2"></i>Войти', [
                            'class' => 'btn btn-primary btn-lg', 
                            'name' => 'login-button'
                        ]) ?>
                    </div>

                    <?php ActiveForm::end(); ?>

                    <div class="text-center mt-4 pt-3 border-top">
                        <p class="text-muted mb-2">Еще не зарегистрированы?</p>
                        <?= Html::a('<i class="fas fa-user-plus me-2"></i>Регистрация', ['site/register'], [
                            'class' => 'btn btn-outline-success'
                        ]) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>