<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Фермерские мемы';
?>

<div class="meme-game">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card shadow-lg border-0">
                <div class="card-header bg-success text-white text-center py-4">
                    <h1 class="display-5 fw-bold mb-2">
                        <i class="fas fa-gamepad me-2"></i>Фермерские мемы
                    </h1>
                    <p class="lead mb-0">Проверь свое чувство юмора и знание фермерской жизни!</p>
                </div>
                
                <div class="card-body p-5">
                    <!-- Счет -->
                    <div class="text-center mb-4">
                        <div class="score-display bg-light rounded-pill py-2 px-4 d-inline-block">
                            <i class="fas fa-star text-warning me-2"></i>
                            <span class="fw-bold fs-4 text-success"><?= $model->score ?></span>
                            <small class="text-muted">очков</small>
                        </div>
                    </div>

                    <?php if ($result): ?>
                        <div class="alert <?= $result['correct'] ? 'alert-success' : 'alert-warning' ?> text-center">
                            <i class="fas <?= $result['correct'] ? 'fa-check-circle' : 'fa-smile-beam' ?> fa-2x mb-3"></i>
                            <h4><?= $comment ?></h4>
                            <?php if (!$result['correct']): ?>
                                <p class="mb-0">Твой ответ: "<strong><?= Html::encode($result['answer']) ?></strong>"</p>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                    <!-- Текущий мем -->
                    <div class="meme-card text-center p-4 bg-light rounded-3 mb-4">
                        <div class="meme-emoji display-1 mb-3">
                            <?= $currentMeme['data']['image'] ?>
                        </div>
                        <h3 class="text-dark mb-4"><?= $currentMeme['data']['question'] ?></h3>
                        
                        <?php $form = ActiveForm::begin([
                            'action' => ['site/meme-game'],
                            'fieldConfig' => [
                                'template' => "{input}",
                                'options' => ['tag' => false]
                            ]
                        ]); ?>
                        
                        <?= Html::hiddenInput('meme_id', $currentMeme['id']) ?>
                        
                        <div class="row g-3">
                            <?php foreach ($currentMeme['data']['options'] as $option => $value): ?>
                                <div class="col-md-6">
                                    <button type="submit" name="MemeGame[choice]" value="<?= Html::encode($option) ?>" 
                                            class="btn btn-outline-success w-100 py-3 fs-5 option-btn">
                                        <?= Html::encode($option) ?>
                                    </button>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        
                        <?php ActiveForm::end(); ?>
                    </div>

                    <!-- Статистика -->
                    <div class="text-center">
                        <div class="row justify-content-center">
                            <div class="col-auto">
                                <div class="card bg-primary text-white">
                                    <div class="card-body py-2">
                                        <small>Всего мемов</small>
                                        <div class="fs-5 fw-bold"><?= count($model::MEMES) ?></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-auto">
                                <div class="card bg-warning text-dark">
                                    <div class="card-body py-2">
                                        <small>Твой рекорд</small>
                                        <div class="fs-5 fw-bold"><?= $model->score ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="card-footer text-center py-3 bg-light">
                    <?= Html::a('<i class="fas fa-home me-2"></i>На главную', ['site/index'], [
                        'class' => 'btn btn-outline-secondary me-2'
                    ]) ?>
                    <?= Html::a('<i class="fas fa-redo me-2"></i>Новая игра', ['site/meme-game'], [
                        'class' => 'btn btn-success'
                    ]) ?>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.option-btn {
    transition: all 0.3s ease;
    border: 2px solid #28a745;
    border-radius: 15px;
    font-weight: 500;
}

.option-btn:hover {
    transform: translateY(-3px) scale(1.02);
    box-shadow: 0 5px 15px rgba(40, 167, 69, 0.3);
    background: #28a745;
    color: white;
}

.meme-emoji {
    font-size: 4rem;
    animation: bounce 2s infinite;
}

@keyframes bounce {
    0%, 100% { transform: translateY(0); }
    50% { transform: translateY(-10px); }
}

.score-display {
    border: 3px solid #ffc107;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0% { transform: scale(1); }
    50% { transform: scale(1.05); }
    100% { transform: scale(1); }
}
</style>